#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/Canvas.h"

NameRect::NameRect(QRectF& rect, QString length, QGraphicsItem * parent) : QGraphicsRectItem(parent)
{
	this->rect = QRectF(rect.x()+1, rect.y()+1, rect.width()-2, (rect.height()-2)/3);
	this->setRect(this->rect);
	this->setBrush(QBrush(Qt::cyan));

	QString buffer("Table");
	buffer = buffer + length;
	
	this->name = new Name(this->rect, buffer, this);
}

void NameRect::DeleteName()
{
	this->setFocus();
	this->name->setPlainText("");
}

NameRect::~NameRect()
{
}
